/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.loot;

import com.google.gson.JsonObject;
import dev.ftb.ftbsbc.tools.ToolsTags;
import dev.ftb.ftbsbc.tools.recipies.ToolsRecipeCache;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class HammerModifier
extends LootModifier {
    public HammerModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> list, LootContext context) {
        ItemStack hammer = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (!(entity instanceof Player && hammer != null && blockState != null && hammer.m_204117_(ToolsTags.Items.HAMMERS) && ToolsRecipeCache.hammerable(blockState))) {
            return list;
        }
        List<ItemStack> hammerDrops = ToolsRecipeCache.getHammerDrops(entity.f_19853_, new ItemStack((ItemLike)blockState.m_60734_()));
        if (hammerDrops.size() > 0) {
            return hammerDrops.stream().map(ItemStack::m_41777_).collect(Collectors.toList());
        }
        return list;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<HammerModifier> {
        public HammerModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new HammerModifier(conditions);
        }

        public JsonObject write(HammerModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

